# 工资最高的人

现有员工信息表如下：

```sql
create table employee
(
    id     serial primary key,
    name   varchar(256),
    dept   varchar(256),
    salary money
);
```

下面哪条查询，可以给出每个部门工资最高的员工的 id, name, dept, salary 四项信息？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
select l.id, l.name, l.dept, l.salary
from employee as l
         join (select max(salary) as salary, dept
               from employee
               group by dept) as r
              on l.dept = r.dept and l.salary = r.salary
```

## 选项

### select 与 group by 不匹配

```sql
select id, name, dept, max(salary)
from employee
group by dept;
```

### group by 不对

```sql
select id, name, dept, max(salary)
from employee
group by dept, id, name;
```

### group by 不对

```sql
select id, name, dept, max(salary)
from employee
group by dept, id, name
having salary = max(salary);
```

### 结构错误

```sql
select id, name, dept, max(salary)
from employee
where salary = max(salary)
group by dept;
```

